!Object constantsFor: 'Geos Libraries'!

geosLIB1 'SYSTEM\ansic'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

vsprintf: __buf with: __format with: __args
	"sword pascal vsprintf(TCHAR *__buf, const TCHAR *__format, va_list __args) in ansi/stdio.h"
	^GEOS call: __buf with: __format with: __args with: #[1 0 1 3 3 3 4]!

sprintf: __buf with: __format with: varargs
	"sword cdecl sprintf(TCHAR *__buf, const TCHAR *__format, ...) in ansi/stdio.h"
	^GEOS call: __buf with: __format with: varargs with: #[129 0 0 3 3 3 4]!

fopen: _filename with: _modeString
	"FILE * pascal fopen(const char *_filename, const char * _modeString) in ansi/stdio.h"
	^GEOS call: _filename with: _modeString with: #[1 0 30 3 3 3]!

fdopen: _fileHan with: _modeString
	"FILE * pascal fdopen(FileHandle _fileHan, const char * _modeString) in ansi/stdio.h"
	^GEOS call: _fileHan with: _modeString with: #[1 0 38 1 3 3]!

fclose: _stream
	"int pascal fclose(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 31 3 4]!

fdclose: _stream
	"FileHandle pascal fdclose(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 39 3 1]!

fseek: _stream with: _posOrOffset with: _mode
	"int pascal fseek(FILE *_stream,dword _posOrOffset, word _mode) in ansi/stdio.h"
	^GEOS call: _stream with: _posOrOffset with: _mode with: #[1 0 29 3 2 1 4]!

ftell: _stream
	"dword pascal ftell(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 32 3 2]!

fwrite: _buf with: _elSize with: _nmemb with: _stream
	"word pascal fwrite(const void * _buf,word _elSize, word _nmemb, FILE *_stream) in ansi/stdio.h"
	^GEOS call: _buf with: _elSize with: _nmemb with: _stream with: #[1 0 33 3 1 1 3 1]!

fread: _buf with: _elSize with: _nmemb with: _stream
	"word pascal fread(void * _buf, word _elSize, word _nmemb, FILE *_stream) in ansi/stdio.h"
	^GEOS call: _buf with: _elSize with: _nmemb with: _stream with: #[1 0 34 3 1 1 3 1]!

fgetc: _stream
	"int pascal fgetc(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 51 3 4]!

fgets: buffer with: buflength with: _stream
	"char * pascal fgets(char *buffer, int buflength, FILE *_stream) in ansi/stdio.h"
	^GEOS call: buffer with: buflength with: _stream with: #[1 0 50 3 4 3 3]!

feof: _stream
	"int pascal feof(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 49 3 4]!

fflush: _stream
	"int pascal fflush(FILE *_stream) in ansi/stdio.h"
	^GEOS call: _stream with: #[1 0 36 3 4]!

rename: _oldName with: _newName
	"int pascal rename(const char * _oldName, const char * _newName) in ansi/stdio.h"
	^GEOS call: _oldName with: _newName with: #[1 0 37 3 3 4]!

atoi: __s
	"int pascal atoi (const TCHAR *__s) in ansi/stdlib.h"
	^GEOS call: __s with: #[1 0 19 3 4]!

_Malloc: blockSize with: geodeHan with: zeroInit
	"void *pascal _Malloc(word blockSize, GeodeHandle geodeHan, word zeroInit) in ansi/stdlib.h"
	^GEOS call: blockSize with: geodeHan with: zeroInit with: #[1 0 26 1 1 1 3]!

_ReAlloc: blockPtr with: newSize with: geodeHan
	"void *pascal _ReAlloc(void *blockPtr, word newSize, GeodeHandle geodeHan) in ansi/stdlib.h"
	^GEOS call: blockPtr with: newSize with: geodeHan with: #[1 0 28 3 1 1 3]!

_Free: blockPtr with: geodeHan
	"void pascal _Free(void *blockPtr, GeodeHandle geodeHan) in ansi/stdlib.h"
	^GEOS call: blockPtr with: geodeHan with: #[1 0 27 3 1 0]!

memchr: __s with: __c with: __n
	"void *pascal memchr (const void *__s, int __c, size_t __n) in ansi/string.h"
	^GEOS call: __s with: __c with: __n with: #[1 0 42 3 4 1 3]!

memcmp: __dest with: __src with: __n
	"int pascal memcmp (const void *__dest, const void *__src, size_t __n) in ansi/string.h"
	^GEOS call: __dest with: __src with: __n with: #[1 0 43 3 3 1 4]!

memcpy: __dest with: __src with: __n
	"void *pascal memcpy (void *__dest, const void *__src, size_t __n) in ansi/string.h"
	^GEOS call: __dest with: __src with: __n with: #[1 0 44 3 3 1 3]!

memmove: __dest with: __src with: __n
	"void *pascal memmove (void *__dest, const void *__src, size_t __n) in ansi/string.h"
	^GEOS call: __dest with: __src with: __n with: #[1 0 45 3 3 1 3]!

memset: __dest with: __c with: __n
	"void *pascal memset (void *__dest, int __c, size_t __n) in ansi/string.h"
	^GEOS call: __dest with: __c with: __n with: #[1 0 46 3 4 1 3]!

strlen: __str
	"word pascal strlen (const TCHAR *__str) in ansi/string.h"
	^GEOS call: __str with: #[1 0 2 3 1]!

STRLEN: __str
	"word pascal STRLEN (const TCHAR *__str) in ansi/string.h"
	^GEOS call: __str with: #[1 0 2 3 1]!

strchr: __s with: __c
	"TCHAR *pascal strchr (const TCHAR *__s, int __c) in ansi/string.h"
	^GEOS call: __s with: __c with: #[1 0 3 3 4 3]!

strrchr: __s with: __c
	"TCHAR *pascal strrchr (const TCHAR *__s, int __c) in ansi/string.h"
	^GEOS call: __s with: __c with: #[1 0 4 3 4 3]!

strncmp: __s with: __t with: __n
	"int pascal strncmp (const TCHAR *__s, const TCHAR *__t, const size_t __n) in ansi/string.h"
	^GEOS call: __s with: __t with: __n with: #[1 0 10 3 3 1 4]!

strcmp: __s with: __t
	"int pascal strcmp (const TCHAR *__s, const TCHAR *__t) in ansi/string.h"
	^GEOS call: __s with: __t with: #[1 0 9 3 3 4]!

strcat: __s with: __t
	"TCHAR *pascal strcat (TCHAR *__s, const TCHAR *__t) in ansi/string.h"
	^GEOS call: __s with: __t with: #[1 0 11 3 3 3]!

strncat: __s with: __t with: __n
	"TCHAR *pascal strncat (TCHAR *__s, const TCHAR *__t, const size_t __n) in ansi/string.h"
	^GEOS call: __s with: __t with: __n with: #[1 0 48 3 3 1 3]!

strcpy: __s with: __t
	"TCHAR *pascal strcpy(TCHAR *__s, const TCHAR *__t) in ansi/string.h"
	^GEOS call: __s with: __t with: #[1 0 7 3 3 3]!

strncpy: __s with: __t with: __n
	"TCHAR *pascal strncpy (TCHAR *__s, const TCHAR *__t, const size_t __n) in ansi/string.h"
	^GEOS call: __s with: __t with: __n with: #[1 0 8 3 3 1 3]!

strcspn: __s with: __set
	"word pascal strcspn (const TCHAR *__s, const TCHAR *__set) in ansi/string.h"
	^GEOS call: __s with: __set with: #[1 0 14 3 3 1]!

strspn: __s with: __set
	"word pascal strspn (const TCHAR *__s, const TCHAR *__set) in ansi/string.h"
	^GEOS call: __s with: __set with: #[1 0 13 3 3 1]!

strpbrk: __s with: __set
	"TCHAR *pascal strpbrk (const TCHAR *__s, const TCHAR *__set) in ansi/string.h"
	^GEOS call: __s with: __set with: #[1 0 15 3 3 3]!

strstr: __s with: __t
	"TCHAR *pascal strstr(const TCHAR *__s, const TCHAR *__t) in ansi/string.h"
	^GEOS call: __s with: __t with: #[1 0 17 3 3 3]!

strpos: __s with: __c
	"word pascal strpos (const TCHAR *__s, int __c) in geomisc.h"
	^GEOS call: __s with: __c with: #[1 0 5 3 4 1]!

strrpos: __s with: __c
	"word pascal strrpos (const TCHAR *__s, int __c) in geomisc.h"
	^GEOS call: __s with: __c with: #[1 0 6 3 4 1]!

itoa: __n with: __s
	"void pascal itoa(int __n, TCHAR *__s) in geomisc.h"
	^GEOS call: __n with: __s with: #[1 0 20 4 3 0]!

strrev: __s
	"void pascal strrev(TCHAR *__s) in geomisc.h"
	^GEOS call: __s with: #[1 0 18 3 0]!

memccpy: __dest with: __src with: __c with: __n
	"void *pascal memccpy(void *__dest, void *__src, word __c, word __n) in geomisc.h"
	^GEOS call: __dest with: __src with: __c with: __n with: #[1 0 47 3 3 1 1 3]!

_Malloc: blockSize with: geodeHan with: zeroInit
	"void *pascal _Malloc(word blockSize, GeodeHandle geodeHan, word zeroInit) in geomisc.h"
	^GEOS call: blockSize with: geodeHan with: zeroInit with: #[1 0 26 1 1 1 3]!

_ReAlloc: blockPtr with: newSize with: geodeHan
	"void *pascal _ReAlloc(void *blockPtr, word newSize, GeodeHandle geodeHan) in geomisc.h"
	^GEOS call: blockPtr with: newSize with: geodeHan with: #[1 0 28 3 1 1 3]!

_Free: blockPtr with: geodeHan
	"void pascal _Free(void *blockPtr, GeodeHandle geodeHan) in geomisc.h"
	^GEOS call: blockPtr with: geodeHan with: #[1 0 27 3 1 0]!

!

